/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ExceptionWrapper;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ThrowingBiConsumer<T, U, TEx extends Throwable> {
    @NotNull
    public static <T, U, TEx extends Throwable> ThrowingBiConsumer<T, U, TEx> of(@NotNull BiConsumer<T, U> consumer) {
        return Objects.requireNonNull(consumer)::accept;
    }

    public void accept(T var1, U var2) throws TEx;

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingConsumer<Tuple<T, U>, TEx> fromTuple() {
        return t -> this.accept(t.left(), t.right());
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingConsumer<V, ? super TEx> compose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> left, @NotNull ThrowingFunction<? super V, ? extends U, ? extends TEx> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return t -> this.accept(left.apply((Object)t), right.apply((Object)t));
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V, W> ThrowingBiConsumer<V, W, TEx> biCompose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> left, @NotNull ThrowingFunction<? super W, ? extends U, ? extends TEx> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return (l, r) -> this.accept(left.apply((Object)l), right.apply((Object)r));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingBiConsumer<V, U, TEx> composeLeft(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return (l, r) -> this.accept(before.apply((Object)l), r);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingBiConsumer<T, V, TEx> composeRight(@NotNull ThrowingFunction<? super V, ? extends U, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return (l, r) -> this.accept(l, before.apply((Object)r));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBiConsumer<T, U, TEx> andThen(@NotNull ThrowingBiConsumer<? super T, ? super U, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.accept(l, r);
            after.accept(l, r);
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBiConsumer<T, U, TEx> andThen(@NotNull ThrowingRunnable<? extends TEx> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.accept(l, r);
            after.run();
        };
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BiConsumer<T, U> addHandler(@NotNull Consumer<Throwable> handler) {
        Objects.requireNonNull(handler);
        return (l, r) -> {
            try {
                this.accept(l, r);
            }
            catch (Throwable e) {
                handler.accept(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BiConsumer<T, U> addHandler(@NotNull Class<TEx> exception, @NotNull Consumer<TEx> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return (l, r) -> {
            try {
                this.accept(l, r);
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    handler.accept(e);
                }
                throw ExceptionWrapper.wrap(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BiConsumer<T, U> orThrow() {
        return this.orThrow(ExceptionWrapper::wrap)::accept;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingBiConsumer<T, U, TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return (l, r) -> {
            try {
                this.accept(l, r);
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    default public BiConsumer<T, U> assumeSafe() {
        ThrowingBiConsumer consumer = this;
        return consumer::accept;
    }
}

